/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.BooleanInputHandler;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;

public class ReadOnlyBooleanInputHandler
extends BooleanInputHandler {
    public static int readOnlyRows;
    private static ReadOnlyBooleanInputHandler _sInputHandler;
    private static final int SPACE = 32;

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mousePressed(mouseEvent, grid, n, n2);
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.toggleValue(grid, n, n2);
        }
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyChar() == ' ') {
            this.toggleValue(grid, n, n2);
        }
    }

    private void toggleValue(Grid grid, int n, int n2) {
        if (grid.fireCancelableCellEvent(n, n2, 2019)) {
            return;
        }
        if (n2 >= readOnlyRows) {
            return;
        }
        TwoDDataSource twoDDataSource = grid.getDataSource();
        Object object = twoDDataSource.getData(n, n2);
        if (object == null) {
            twoDDataSource.setData(n, n2, (Object)Boolean.TRUE);
        } else if (((Boolean)object).booleanValue()) {
            twoDDataSource.setData(n, n2, (Object)Boolean.FALSE);
        } else {
            twoDDataSource.setData(n, n2, (Object)Boolean.TRUE);
        }
        grid.fireCellEvent(n, n2, 2020);
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = new ReadOnlyBooleanInputHandler();
        }
        return _sInputHandler;
    }

    protected ReadOnlyBooleanInputHandler() {
    }
}

